<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProduceItems extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('produce_items', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->integer('produce_id')->unsigned();
            $table->integer('produce_unit_id')->unsigned();
            $table->decimal('price_per_unit', 13, 4)->default(0);
            $table->integer('tonnage');
            $table->string('quality', 65);
            $table->boolean('approved')->default("1");
            $table->decimal('balance', 13, 4)->default(0);
            $table->timestamps();

            $table->foreign('trader_id','trading_produce_items_trader_id_foreign')->references('id')->on('traders')->onDelete('cascade');
            $table->foreign('produce_id','trading_produce_items_produce_id_foreign')->references('id')->on('produce')->onDelete('cascade');
            $table->foreign('produce_unit_id','trading_produce_items_produce_unit_id_foreign')->references('id')->on('produce_units');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::table('produce_items', function (Blueprint $table) {
            $table->dropForeign('trading_produce_items_trader_id_foreign');
            $table->dropForeign('trading_produce_items_produce_id_foreign');
		    $table->dropForeign('trading_produce_items_produce_unit_id_foreign');
        });

        Schema::dropifExists('produce_items');
    }

}
