<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRegionTrader extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('region_trader', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->integer('region_id')->unsigned();
            $table->integer('trader_id')->unsigned();
            $table->timestamps();

            $table->foreign('region_id','trading_region_trader_region_id_foreign')->references('id')->on('regions')->onDelete('cascade');
            $table->foreign('trader_id','trading_region_trader_trader_id_foreign')->references('id')->on('traders')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::table('region_trader', function (Blueprint $table) {
            $table->dropForeign('trading_region_trader_region_id_foreign');
		      	$table->dropForeign('trading_region_trader_trader_id_foreign');
        });

        Schema::dropifExists('region_trader');
    }

}
