<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Expression;

class CreateAgentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('agents', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();
            $table->bigIncrements('agent_id');
            $table->integer('trader_id')->length(10)->unsigned()->nullable();
            $table->integer('user_id')->length(10)->unsigned()->nullable();
            $table->timestamps();
            //foreigns
            $table->foreign('trader_id')->references('id')->on('traders')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('user_id')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('agents', function (Blueprint $table){
            $table->dropForeign('trader_id');
            $table->dropForeign('user_id');
        });
        Schema::dropIfExists('agents');
    }
}
