<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Expression;

class CreateTraders extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('traders', function (Blueprint $table) {
            $database = DB::connection("mysql_lms")->getDatabaseName();

            $table->integerIncrements('id')->unsigned();
            $table->string('organisation_name')->nullable();
            $table->integer('type_id')->unsigned();
            $table->integer('user_id');
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('postal_address')->nullable();
            $table->string('physical_address')->nullable();
            $table->string('latitude')->nullable();
            $table->string('longitude')->nullable();
            $table->integer('region_id')->unsigned()->nullable();
            $table->integer('county_id')->unsigned()->nullable();
            $table->string('ward')->nullable();
            $table->text('preferred_regions')->nullable();
            $table->string('tonnage_per_year')->nullable();
            $table->string('destination_markets')->nullable();
            $table->string('special_terms')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();

            $table->foreign('user_id','trading_trader_user_id_foreign')->references('id')->on(new Expression($database . '.user'))->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('type_id','trading_trader_type_id_foreign')->references('id')->on('trader_type')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('region_id','trading_trader_region_id_foreign')->references('id')->on('region_id')->onUpdate('CASCADE')->onDelete('RESTRICT');
            $table->foreign('county_id','trading_trader_county_id_foreign')->references('id')->on('county_id')->onUpdate('CASCADE')->onDelete('RESTRICT');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('traders', function (Blueprint $table) {
            $table->dropForeign('trading_trader_user_id_foreign');
            $table->dropForeign('trading_trader_type_id_foreign');
            $table->dropForeign('trading_trader_region_id_foreign');
            $table->dropForeign('trading_trader_county_id_foreign');
        });

        Schema::dropifExists('traders');
    }
}
