<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProduceCategories extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        Schema::create('produce_categories', function (Blueprint $table) {
            $table->integerIncrements('id')->unsigned();
            $table->string('name');
            $table->text('description')->nullable();
            $table->integer('parent_id')->unsigned()->nullable();
            $table->timestamps();

            $table->foreign('parent_id','trading_produce_categories_parent_id_foreign')->references('id')->on('produce_categories')->onUpdate('CASCADE')->onDelete('RESTRICT');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::table('produce_categories', function(Blueprint $table)
		{
            $table->dropForeign('trading_produce_categories_parent_id_foreign');
        });

        Schema::dropIfExists('produce_categories');
    }
}
