<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class inputOrders extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_input_orders';

    protected $fillable = [
        'trader_id',
        'expected_date',
        'description',
        'approved',
        'approved_by',
        'total'
    ];

    protected $appends = [
        'url'
    ];

    public function getUrlAttribute() {
        return route("input_orders.show", $this);
    }

    public function orderItems() {
        return $this->HasMany(inputOrderItems::class, 'order_id');
    }
    public function inputDelivery() {
        return $this->HasMany(Delivery::class);
    }
    public function inputsRelease() {
        return $this->hasMany(InputOrderItemsRelease::class);
    }
    // public function inputOrder() {
    //     return $this->belongsTo(Trader::class, 'trader_id', 'id');
    // }
    public function trader() {
        return $this->belongsTo(Trader::class);
    }
}
