<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class inputOrderItems extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_input_order_items';

    protected $fillable = [
        'order_id',
        'farmer_id',
        'input_item_id',
        'quantity',
        'expected_date',
        'description',
        'directed_to',
        'financing',
        'price',
        'approved'
    ];

    //
    public function farmer() {
        return $this->belongsTo(User::class, 'farmer_id', 'id');
    }

    public function orders() {
        return $this->belongsTo(inputOrders::class, 'order_id','id');
    }

    public function input() {
        return $this->belongsTo(InputItem::class, 'input_item_id','id');
    }

    public function trader() {
        return $this->belongsTo(Trader::class, 'directed_to','id');
    }

    public function inputOrderItem() {
        return $this->hasMany(Invoice::class);
    }

    public function crs() {
        return $this->hasMany(Credits::class, 'input_order_item_id');
    }

    public function inputReleases() {
        return $this->hasMany(InputReleases::class,'input_order_item_id');
    }
}
