<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Vehicle extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_vehicles';
    //
    protected $fillable = [
        'make',
        'model',
        'tonnage',
        'plate',
        'trader_id',
        'description',
        'status'
    ];

    public function vehicles()
    {
       return $this->belongsTo(Trader::class, 'trader_id', 'id');
    }

    public function vehicle()
    {
       return $this->hasMany(Delivery::class);
    }
}
