<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class UserWalletTransaction extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_user_wallet_transactions';

    protected $fillable = [
        'wallet_id',
        'amount',
        'hash',
        'user_wallet_id',
        'type',
        'meta'
    ];

    protected $casts = [
        'amount' => 'float',
        'meta' => 'json'
    ];

    public function wallet() {
        return $this->belongsTo(UserWallet::class);
    }

    /**
     * Retrieve the amount with the positive or negative sign
     */
    public function getAmountWithSignAttribute()
    {
        return in_array($this->type, ['deposit', 'refund'])
            ? '+' . $this->amount
            : '-' . $this->amount;
    }
}
