<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class UserWallet extends Model
{
    use HasTradingPrefix;

    protected $table = 'trading_user_wallets';

    protected $fillable = [
        'user_id',
        'balance',
        'float_bal',
        'last_updated',
    ];

    public function user() {
        return $this->belongsTo(User::class);
    }

    public function transactions() {
        return $this->HasMany(UserWalletTransaction::class);
    }
}
