<?php

namespace App;

use Illuminate\Support\Facades\Config;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\HasWallet;
use App\Trader;
use App\TraderMember;

class User extends Authenticatable {

    use Notifiable, HasWallet,SoftDeletes;

    protected $table = 'user';

    protected $fillable = [
        'username',
        'username_canonical',
        'firstname',
        'lastname',
        'email',
        'email_canonical',
        'phone',
        'salt',
        'address',
        'user_id',
        'roles',
        'locked',
        'enabled',
        'expired',
        'credentials_expired',
        'registration_date',
        'active',
        'status',
        'password',
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function __construct(array $attributes = array()) {
        $collection = Config::get('database');
        $collection['connections']['mysql']['prefix'] = '';
        Config::set('database', $collection);

        parent::__construct($attributes);
    }

    public function getFullnameAttribute() {
        return sprintf("%s %s", $this->firstname, $this->lastname);
    }

    public function getUrlAttribute() {
        return route("users.show", $this->id);
    }

    public function getTraderAttribute() {
        return $this->traderMember->trader;
    }

    public function scopeWhereUsername($query, $username) {
        $query->where('username', $username);
    }

    // public function trader() {
    //     return $this->hasOne(Trader::class);
    // }

    //return related administrator
    public function getRelatedAdmin() {
        return Administrator::where('user_id', $this->id)->first();
    }

    public function isAdmin() {
        $admin = $this->getRelatedAdmin();
        return !is_null($admin);
    }


    public function getRelatedTrader() {
         return Trader::where('user_id', $this->id)->first();
        /* if(Trader::where('user_id', $this->id)->first() != '')
        {
        return Trader::where('user_id', $this->id)->first();
        }
        else if(TraderMember::where('user_id', $this->id)->first() != '')
        {
            return TraderMember::where('user_id', $this->id)->where('type','agent')->first();
        } */
    }

    // public function getRelatedAgent() {
    //     if(Trader::where('user_id', $this->id)->first() != '')
    //     {
    //     return Trader::where('user_id', $this->id)->first();
    //     }
    //     else if(TraderMember::where('user_id', $this->id)->first() != '')
    //     {
    //         return TraderMember::where('user_id', $this->id)->where('type','agent')->first();
    //     }
    // }

    public function isTraderAdmin() {
        $admin = $this->getRelatedTrader();
        return !is_null($admin);
    }

    public function inputOrderItems() {
        return $this->hasMany(inputOrderItems::class);
    }

    public function aggregations() {
        return $this->hasMany(FarmerProduceAggregation::class, 'farmer_id', 'id');
    }

    public function traderMember() {
        return $this->hasOne(TraderMember::class, 'user_id', 'id');
    }

    public function trader() {
        return $this->belongsTo(Trader::class, 'user_id');
    }

    public function userDriver()
    {
       return $this->hasMany(Driver::class);
    }

    public function farmer_profile()
    {
        return $this->hasOne(FarmerProfile::class, 'user_id', 'id');
    }

    public function farmer_creddit() {
        return $this->hasMany(Credits::class);
    }

    public function userAgent()
    {
        return $this->hasMany(Agent::class,'user_id');
    }

    //=====relationships======//
    //Expert video <> farmer rlshp
    public function videoCoach()
    {
        return $this->belongsTo(Expert_Videos::class, 'expert_id');
    }


}
