<?php

namespace App\Traits;

trait HasTablePrefix
{

    /**
     * Get the table associated with the model.
     *
     * @return string
     */
    public function getTable()
    {
        if (substr( parent::getTable(), 0, 8 ) !== "trading_")
            return $this->getPrefix() . parent::getTable();

        return parent::getTable();
    }

    /**
     * Get the prefix associated with the model.
     *
     * @return string
     */
    public function getPrefix()
    {
        return is_null($this->prefix) ? '' : $this->prefix;
    }

    /**
     * Set the prefix associated with the model.
     *
     * @param  string $prefix
     * @return $this
     */
    public function setPrefix($prefix)
    {
        $this->prefix = $prefix;

        return $this;
    }

}
