<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
use App\Trader;

class TraderType extends Model
{
    //use HasTradingPrefix;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_trader_type';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name'
    ];

    /**
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
        'url'
    ];

    /**
     * Get the url for this model.
     *
     * @return URL
     */
    public function getUrlAttribute()
    {
        return route("trader-types.show", $this);
    }

    public function traders() {
        return $this->hasMany(Trader::class);
    }
}
