<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
use App\Trader;

class TraderSetting extends Model
{
    //use HasTradingPrefix;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_trader_settings';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'trader_id',
        'locked',
        'credit_limit'
    ];

    /**
     * Get the trader for this model.
     *
     * @return App\Trader
     */
    public function trader()
    {
        return $this->belongsTo(Trader::class);
    }


}
