<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class TraderNetwork extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_trader_networks';

    protected $fillable = [
        'trader_id',
        'type',
        'region_id',
        'county_id',
        'agrodealer_id',
        'description'
    ];

    /**
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
        'url'
    ];

    public function getUrlAttribute() {
        return route("trader-networks.show", $this);
    }

    public function trader() {
        return $this->belongsTo(Trader::class, 'trader_id', 'id');
    }

    public function region() {
        return $this->belongsTo(Region::class, 'region_id', 'id');
    }

    public function county() {
        return $this->belongsTo(County::class, 'county_id', 'id');
    }

    public function agrodealer() {
        return $this->belongsTo(Trader::class, 'agrodealer_id', 'id');
    }
}
