<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
use App\Trader;
use App\User;

class TraderMember extends Model
{
    //use HasTradingPrefix;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_trader_members';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'trader_id',
        'active',
        'type'
    ];

    /**
     * Get the trader for this model.
     *
     * @return App\Trader
     */
    public function trader()
    {
        return $this->belongsTo(Trader::class, 'trader_id', 'id');
    }

    /**
     * Get the user for this model.
     *
     * @return App\User
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }


}
