<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
use App\Trader;

class TraderContract extends Model
{
    //use HasTradingPrefix;

     /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_trader_contracts';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'trader_id',
        'name',
        'contract_file',
        'produce_id',
        'produce_unit_id',
        'price_per_unit',
        'tonnage',
        'active'
    ];

    /**
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
        'url',
        'fulfilled'
    ];

    /**
     * Get the url for this model.
     *
     * @return URL
     */
    public function getUrlAttribute() {
        return route("trader-contracts.show", $this);
    }

    public function getFulfilledAttribute() {
        $fulfilled = 0;

        foreach ($this->contract_details as $contract_detail) {
            $fulfilled += $contract_detail->tonnage;
        }

        return ($fulfilled / $this->tonnage) * 100;
    }

    public function trader() {
        return $this->belongsTo(Trader::class, 'trader_id','id');
    }

    public function produce() {
        return $this->belongsTo(Produce::class);
    }

    public function produce_unit() {
        return $this->belongsTo(ProduceUnit::class);
    }

    public function contract_details() {
        return $this->HasMany(ContractDetail::class, 'contract_id', 'id');
    }

    public function produce_items() {
        return $this->HasMany(ProduceItem::class);
    }
}
