<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
use App\Trader;
use App\User;

class TraderContact extends Model
{
    //use HasTradingPrefix;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_trader_contacts';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'trader_id',
        'firstname',
        'lastname',
        'email',
        'phone',
        'user_id',
        'is_admin'
    ];

    /**
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
        'url'
    ];

    /**
     * Get the url for this model.
     *
     * @return URL
     */
     public function getUrlAttribute()
     {
         return route("traders.show", $this);
     }

     /**
     * Get the url for this model.
     *
     * @return URL
     */
    public function getFullnameAttribute()
    {
        return sprintf("%s %s", $this->firstname, $this->lastname);
    }

    /**
     * Get the trader for this model.
     *
     * @return App\Trader
     */
    public function trader()
    {
        return $this->belongsTo(Trader::class);
    }

    /**
     * Get the user for this model.
     *
     * @return App\User
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
