<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Config;
use App\Traits\HasTradingPrefix;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\TraderMember;
use App\User;
use Auth;

class Trader extends Model
{
    //use HasTradingPrefix;
    use SoftDeletes;
    
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_traders';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'organisation_name',
        'type_id',
        'user_id',
        'email',
        'phone',
        'postal_address',
        'buyer_type',
        'physical_address',
        'region_id',
        'county_id',
        'ward',
        'preferred_regions',
        'status'
    ];

    /**
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
        'url'
    ];

    public function scopeWithAndWhereHas($query, $relation, $constraint){
        return $query->whereHas($relation, $constraint)->with([$relation => $constraint]);
    }

    public function getUrlAttribute() {
        return route("traders.show", $this);
    }

    // public function getPreferredRegionsAttribute() {
    //     return implode(', ', $this->regions()->pluck('name')->toArray());
    // }

    public function user() {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function trader_type() {
        return $this->belongsTo(TraderType::class, 'type_id');
    }

    public function regions() {
        return $this->belongsToMany(Region::class);
    }

    public function region() {
        return $this->belongsTo(Region::class, 'region_id');
    }

    public function county() {
        return $this->belongsTo(County::class, 'county_id');
    }

    public function contacts() {
        return $this->HasMany(TraderContact::class);
    }

    public function contracts() {
        return $this->HasMany(TraderContract::class);
    }

    public function members() {
        return $this->HasMany(TraderMember::class);
    }
    

    public function produce_items() {
        return $this->HasMany(ProduceItem::class);
    }

    public function networks() {
        return $this->HasMany(TraderNetwork::class, 'trader_id', 'id');
    }

    public function settings() {
        return $this->hasOne(TraderSetting::class, 'trader_id', 'id');
    }

   
    public function isFarmerOrganisation() {
        // if($this->trader_type->name == "Farmer Organ isation")
            return $this->trader_type->name == "Farmer Organisation";
        // return $this->members['type'] == "Agent";
    }

    public function isBulkBuyer() {
        return $this->trader_type->name == "BTCotton Buyer";
    }

    public function isBulkSeller() {
        return $this->trader_type->name == "BTCotton Seller";
    }

    public function isAgroDealer() {
        return $this->trader_type->name == "Agrodealer";
    }
    

    public function isTransporter() {
        return $this->trader_type->name == "Transporter";
    }
    // //added for agent login
        
    public function isAgent() {
        return $this->trader_type->name == "Expert";
    }
    // //find agent
    // public function getType($id) {
    //     $type = TraderMember::where('user_id',$id)->first();
    //     return $type['type'];
    // }
    public function tradingOrder() {
        return $this->hasMany(Order::class, 'trader_id', 'id');
    }

    public function traders() {
        return $this->hasMany(Order::class,'directed_to','id');
    }
    public function inputitem() {
        return $this->hasMany(InputItem::class);
    }
    public function inputorderitem() {
        return $this->hasMany(inputOrderItems::class,'directed_to');
    }

    public function users() {
        return $this->belongsToMany(User::class, 'trading_trader_members', 'trader_id', 'user_id');
    }
    public function tradeDriver() {
       return $this->hasMany(Driver::class);
    }
    public function deliveryRequests() {
        return $this->hasMany(DeliveryRequests::class);
     }
     public function deliveryAcknowledgement() {
        return $this->hasMany(DeliveryAcknowledgement::class);
     }
     public function invoice() {
        return $this->hasMany(Invoice::class, 'directed_to');
    }
    //agent --- trader
    public function traderAgent()
    {
        return $this->belongsTo(Agent::class,'trader_id');
    }

        //Expert video <> Trader rlshp
        public function audoTrader()
        {
            return $this->hasMany(Expert_Audios::class, 'id');
        }
    //=====relationships======//
    //Expert video <> farmer rlshp
    public function videoOrganization()
    {
        return $this->belongsTo(Expert_Videos::class, 'id');
    }


    public function traderchart() {
        return $this->hasMany(Chat::class,'id');
    }

    public function tradercounty() {
        return $this->belongsTo(County::class,'id');
    }


}
