<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
class SeasonProduce extends Model
{
    //use HasTradingPrefix;
    //SeasonProduce
    protected $table = 'trading_season_produces';
    protected $primaryKey = 'season_produce_id';
    protected $fillable = [
        'produce_item_id',
        'season_id',
        'quality',
        'recommended_seed',
        'fertilizer',
        'pesticides',
        'sowing_date',
        'sowing_area',
        'yield_estimation',
        'est_harvestdate'
    ];
    //=====relationships======//
    //seasonproduce <> produce rlshp
    public function seasonproduceProduce()
    {
        return $this->belongsTo(ProduceItem::class, 'produce_item_id','id');
    }
    //seasonproduce <> season rlshp
    public function seasonproduceSeason()
    {
        return $this->belongsTo(Season::class, 'season_id','season_id');
    }
    //seasonproduce <> additional rlshp
    public function seasonproduceAdditional()
    {
        return $this->hasMany(AdditionalSeasonalProduce::class, 'season_produce_id');
    }
}
