<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
class Season extends Model
{
    //use HasTradingPrefix;
    //Season
    protected $table = 'trading_seasons';
    protected $primaryKey = 'season_id';
    protected $fillable = [
        'season',
        'year',
        'farmer_id'
    ];
    //=====relationships======//
    //season <> farmer rlshp
    public function soilFarmer()
    {
        return $this->belongsTo(FarmerProfile::class, 'farmer_id','id');
    }
    //season <> season produce
    public function seasonSeasonproduce()
    {
        return $this->hasMany(SeasonProduce::class, 'season_id');
    }
}