<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Region extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_regions';

    protected $fillable = [
        'name',
        'description'
    ];

    public function getUrlAttribute() {
        return route("regions.show", $this->id);
    }

    public function networks() {
        return $this->hasMany(TraderNetwork::class, 'region_id');
    }

    public function traders() {
        return $this->hasMany(Trader::class, 'region_id');
    }

}
