<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider {

    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        'App\Item' => 'App\Policies\ItemPolicy',
        'App\Message' => 'App\Policies\MessagePolicy',
        'App\ProductCategory' => 'App\Policies\ProductCategoryPolicy',
        'App\Product' => 'App\Policies\ProductPolicy',
        'App\Region' => 'App\Policies\RegionPolicy',
        'App\Trader' => 'App\Policies\TraderPolicy',
        'App\Unit' => 'App\Policies\UnitPolicy',
        'App\User' => 'App\Policies\UserPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot() {
        $this->registerPolicies();
    }

}
