<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class ProduceUnit extends Model
{
    //use HasTradingPrefix;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_produce_units';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'description',
        'abbreviation',
    ];

    /**
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
        'url'
    ];

    public function getUrlAttribute() {
        return route("produce-units.show", $this);
    }

    public function produce_items() {
        return $this->hasMany(ProduceItem::class, 'produce_unit_id');
    }

    public function contracts() {
        return $this->hasMany(TraderContract::class, 'produce_unit_id');
    }
}
