<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
use App\ContractDetail;

class ProduceOrderItem extends Model
{
    //use HasTradingPrefix;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_produce_order_items';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'produce_order_id',
        'contract_id',
        'price_per_unit',
        'quantity',
        'expected_date',
        'description',
        'approved'
    ];

    /**
     * Get the order for this model.
     *
     * @return App\Order
     */
    public function produce_order() {
        return $this->belongsTo(ProduceOrder::class, 'produce_order_id','id');
    }

    public function contract() {
        return $this->belongsTo(TraderContract::class, 'contract_id','id');
    }
}
