<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
use App\Trader;

class ProduceOrder extends Model
{
    //use HasTradingPrefix;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_produce_orders';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'trader_id',
        'approved',
        'total'
    ];

    /**
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
        'url'
    ];

    /**
     * Get the url for this model.
     *
     * @return URL
     */
     public function getUrlAttribute()
     {
         return route("produce-orders.show", $this);
     }

    /**
     * Get the trader for this model.
     *
     * @return App\Trader
     */
    public function trader() {
        return $this->belongsTo(Trader::class,'trader_id','id');
    }

    public function produce_order_items() {
        return $this->hasMany(ProduceOrderItem::class);
    }
    public function produceDelivery() {
        return $this->HasMany(Delivery::class);
    }
    public function deliveryRequests() {
        return $this->hasMany(DeliveryRequests::class);
     }
     public function produceOrder() {
        return $this->hasMany(Invoice::class);
    }
    public static function boot() {
        parent::boot();

        self::deleting(function($produce_order) { // before delete() method call this
             $produce_order->produce_order_items()->each(function($produce_order_item) {
                $produce_order_item->delete();
             });

             // do the rest of the cleanup...
        });
    }
}
