<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
use App\ProduceCollection;

class ProduceItem extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_produce_items';

    protected $fillable = [
        'trader_id',
        'produce_id',
        'produce_unit_id',
        'price_per_unit',
        'tonnage',
        'quality',
        'approved',
        'balance'
    ];

    /**
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
        'url',
        'pending_collections',
        'available_balance',
    ];

    public function getUrlAttribute() {
        return route("produce-items.show", $this->id);
    }

    public function getPendingCollectionsAttribute() {
        $produce_item_id = $this->id;

        return ProduceCollection::whereHas('contract_detail', function($query) use($produce_item_id) {
            $query->whereHas('produce_item', function($query) use($produce_item_id) {
                $query->where('id', $produce_item_id);
            });
        })->where('status', 0)->sum('quantity');
    }

    public function getAvailableBalanceAttribute() {
        $available_balance = $this->pending_collections == 0 ? $this->balance : $this->balance - $this->pending_collections;
        return number_format($available_balance, 0, '.', '');
    }

    public function trader() {
        return $this->belongsTo(Trader::class);
    }

    public function produce() {
        return $this->belongsTo(Produce::class);
    }
// 'produce_unit_id','id'
    public function produce_unit() {
        return $this->belongsTo(ProduceUnit::class);
    }

    public function contract_details() {
        return $this->HasMany(ContractDetail::class, 'produce_item_id', 'id');
    }

    public function aggregations() {
        return $this->HasMany(FarmerProduceAggregation::class, 'produce_item_id', 'id');
    }
    //produce item <> season produce
    public function produceSeasonproduce()
    {
        return $this->hasMany(SeasonProduce::class, 'produce_item_id');
    }
    /******************************************************************/

    /* DEPRECATED: REMOVE */

    public function stocks() {
        return $this->hasMany(Stock::class);
    }

    public function getAmountAttribute() {
        return $this->stocks()->sum('amount');
    }

    /* END DEPRECATED */

}
