<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class ProduceCollection extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_produce_collections';

    protected $primaryKey = 'id';

    protected $fillable = [
        'contract_detail_id',
        'quantity',
        'status',
        'collected_by',
        'approved_by'
    ];

    // public function getStatusAttribute() {

    //     return $this->status;
    // }

    public function collector() {
        return $this->belongsTo(User::class, 'collected_by', 'id');
    }

    public function approver() {
        return $this->belongsTo(User::class, 'approved_by', 'id');
    }

    public function contract_detail() {
        return $this->belongsTo(ContractDetail::class, 'contract_detail_id', 'id');
    }

    public function invoice() {
        return $this->hasOne(Invoice::class, 'produce_collection_id', 'id');
    }

    public function delivery() {
        return $this->hasOne(Delivery::class, 'produce_collection_id', 'id');
    }

    public function delivery_request() {
        return $this->hasOne(DeliveryRequests::class, 'produce_collection_id', 'id');
    }

}
