<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class ProduceCategory extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_produce_categories';

    protected $fillable = [
        'name',
        'description',
        'parent_id'
    ];

    public function produce() {
        return $this->hasMany(Produce::class, 'category_id');
    }

    public function children() {
        return $this->hasMany(ProduceItem::class, 'parent_id');
    }

    public function categories() {
        return $this->HasMany(ProduceCategory::class);
    }

    public function childrenCategories() {
        return $this->hasMany(ProduceCategory::class)->with('categories');
    }

    public function parent() {
        return $this->belongsTo(ProduceCategory::class, 'parent_id');
    }

    public function scopeMain($query) {
        $query->whereNull('parent_id');
    }

    /**
     * Get the url for this model.
     *
     * @return URL
     */
    public function getUrlAttribute()
    {
        return route("produce-categories.show", $this);
    }

}
