<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Produce extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_produce';

    protected $fillable = [
        'category_id',
        'name',
        'description',
        'listed'
    ];

    public function getUrlAttribute() {
        return route("produce-items.show", $this->id);
    }

    public function category() {
        return $this->belongsTo(ProduceCategory::class);
    }

    public function produce_items() {
        return $this->hasMany(ProduceItem::class, 'produce_id');
    }

    public function contracts() {
        return $this->hasMany(TraderContract::class, 'produce_id');
    }

}
