<?php

namespace App\Policies;

use App\Trader;
use App\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class TraderPolicy {

    use HandlesAuthorization;

    public function before(User $user, $ability) {
        if ($user->isAdmin()) {
            return true;
        }
    }

    public function viewAny(User $user) {
        return $user->isAdmin();
    }

    public function view(User $user, Trader $trader) {
        return $user->isAdmin();
    }

    public function create(User $user) {
        return $user->isAdmin();
    }

    public function update(User $user, Trader $trader) {
        return $user->isAdmin();
    }

    public function delete(User $user, Trader $trader) {
        return $user->isAdmin();
    }

    public function activate(User $user) {
        return $user->isAdmin();
    }

    public function deactivate(User $user) {
        return $user->isAdmin();
    }

}
