<?php

namespace App\Policies;

use App\Region;
use App\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class RegionPolicy {

    use HandlesAuthorization;

    public function before(User $user, $ability) {
        if ($user->isAdmin()) {
            return true;
        }
    }

    public function viewAny(User $user) {
        return $user->isAdmin();
    }

    public function view(User $user, Region $region) {
        return $user->isAdmin();
    }

    public function create(User $user) {
        return $user->isAdmin();
    }

    public function update(User $user, Region $region) {
        return $user->isAdmin();
    }

    public function delete(User $user, Region $region) {
        return $user->isAdmin();
    }

}
