<?php

namespace App\Policies;

use App\Product;
use App\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class ProductPolicy {

    use HandlesAuthorization;

    public function before(User $user, $ability) {
        if ($user->isAdmin()) {
            return true;
        }
    }

    public function viewAny(User $user) {
        return $user->isAdmin();
    }

    public function view(User $user, Product $product) {
        return $user->isAdmin();
    }

    public function create(User $user) {
        return $user->isAdmin();
    }

    public function update(User $user, Product $product) {
        return $user->isAdmin();
    }

    public function delete(User $user, Product $product) {
        return $user->isAdmin();
    }

}
