<?php

namespace App\Policies;

use App\ProductCategory;
use App\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class ProductCategoryPolicy {

    use HandlesAuthorization;

    public function before(User $user, $ability) {
        if ($user->isAdmin()) {
            return true;
        }
    }

    public function viewAny(User $user) {
        return $user->isAdmin();
    }

    public function view(User $user, ProductCategory $productCategory) {
        return $user->isAdmin();
    }

    public function create(User $user) {
        return $user->isAdmin();
    }

    public function update(User $user, ProductCategory $productCategory) {
        return $user->isAdmin();
    }

    public function delete(User $user, ProductCategory $productCategory) {
        return $user->isAdmin();
    }

}
