<?php

namespace App\Policies;

use App\Message;
use App\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class MessagePolicy {

    use HandlesAuthorization;

    public function before(User $user, $ability) {
        if ($user->isAdmin()) {
            return true;
        }
    }

    public function viewAny(User $user) {
        return $user->isAdmin();
    }

    public function view(User $user, Message $message) {
        return $user->isAdmin() || $message->user_id == $user->id;
    }

    public function create(User $user) {
        return true;
    }

    public function delete(User $user, Message $message) {
        return $user->isAdmin() || $message->user_id == $user->id;
    }

}
