<?php

namespace App\Policies;

use App\Item;
use App\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class ItemPolicy {

    use HandlesAuthorization;

    public function before(User $user, $ability) {
        if ($user->isAdmin()) {
            return true;
        }
    }

    public function viewAny(User $user) {
        return $user->isAdmin();
    }

    public function view(User $user, Item $item) {
        return $user->isAdmin();
    }

    public function create(User $user) {
        return $user->isAdmin();
    }

    public function update(User $user, Item $item) {
        return $user->isAdmin();
    }

    public function delete(User $user, Item $item) {
        return $user->isAdmin();
    }

}
