<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class News extends Model
{
    //
    protected $table='trading_news';

    protected $fillable =[
        'title',
        'content',
        'image',
        'newscategory_id',
        'user_id',
        'status'
    ];
    //relationship
    public function newsAdmin()
    {
        return $this->belongsTo(User::class, 'user_id','id');
    }
    public function newsCategory()
    {
        return $this->belongsTo(NewsCategory::class, 'newscategory_id','id');
    }

}
