<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Livestock extends Model
{
    //use HasTradingPrefix;
    protected $table ="trading_livestocks";
    protected $primaryKey = 'livestock_id';
    protected $fillable = [
        'animal',
        'breed',
        'sex',
        'weight',
        'age',
        'disease_history',
        'purpose',
        'intake',
        'yields',
        'tag_number',//tag_no
        'agent_id',
        'farmer_id',
        //add animal foreign
        'parent_id'
    ];
    //=====relationships======//
    //livestock <> farmer rlshp
    public function livestockFarmer()
    {
        return $this->belongsTo(FarmerProfile::class, 'farmer_id','id');
    }
    public function livestockParent()
    {
        return $this->hasMany(Livestock::class, 'parent_id');
    }
    public function livestockChild()
    {
        return $this->belongsTo(Livestock::class, 'parent_id','livestock_id');
    }
}
