<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class InvoicePayment extends Model
{
    //use HasTradingPrefix;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_invoice_payments';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
                  'invoice_id',
                  'mode',
                  'amount',
                  'reference',
                  'date'
              ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
               'date'
           ];

    /***
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
                  'url'
              ];

     /**
     * Get the url for this model.
     *
     * @return URL
     */
     public function getUrlAttribute()
     {
         return route("invoicepayments.show", $this);
     }

    /**
     * Get the Invoice for this model.
     *
     * @return App\Invoice
     */
    public function Invoice()
    {
        return $this->belongsTo(Invoice::class,'invoice_id','id');
    }

    /**
     * Set the date.
     *
     * @param  string  $value
     * @return void
     */
    public function setDateAttribute($value)
    {
        $this->attributes['date'] = !empty($value) ? \DateTime::createFromFormat('d-m-Y', $value) : null;
    }



}
