<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Invoice extends Model
{
    //use HasTradingPrefix;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_invoices';

    /**
    * The database primary key value.
    *
    * @var string
    */
    protected $primaryKey = 'id';

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
               'date'
           ];

    /***
     * Add url attributes to the model.
     *
     * @var array
     */
    // protected $appends = [
    //     'url'
    // ];

     /**
     * Get the url for this model.
     *
     * @return URL
     */
    //  public function getUrlAttribute()
    //  {
    //      return route("invoices.show", $this);
    //  }

    /**
     * Get the order for this model.
     *
     * @return App\Order
     */
    public function invoice()
    {
        return $this->belongsTo(inputOrderItems::class,'input_item_id','id');
    }
    public function invoiceproduce()
    {
        return $this->belongsTo(ProduceCollection::class,'produce_collection_id','id');
    }
    public function invoices()
    {
        return $this->belongsTo(Trader::class,'directed_to','id');
    }

    /**
     * Set the date.
     *
     * @param  string  $value
     * @return void
     */
    public function setDateAttribute($value)
    {
        $this->attributes['date'] = !empty($value) ? \DateTime::createFromFormat('d-m-Y', $value) : null;
    }
    protected $fillable = [
        'input_item_id',
        'produce_collection_id',
        'number',
        'total',
        'balance',
        'type',
        'direction'
        ];

}
