<?php
namespace App;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;
class InputOrderItemsRelease extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_input_order_items_releases';

    protected $fillable = [
        'recipient',
         'means',
         'date',
         'order_id',
         'trader_id',
         'status'
    ];

    public function inputOrders() {
        return $this->belongsTo(inputOrders::class, 'order_id', 'id');
    }

    public function inputOrderItemsRelease() {
        return $this->belongsTo(Trader::class, 'trader_id', 'id');
    }

    public function release() {
        return $this->hasMany(InputDeliveryConfirm::class);
    }

}
