<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class InputItem extends Model
{
    //use HasTradingPrefix;

     /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_input_items';

    protected $fillable = [
        'name',
        'trader_id',
        'input_id',
        'input_unit_id',
        'price_per_unit',
        'listed'
    ];

    public function getUrlAttribute() {
        return route("input-items.show", $this->id);
    }

    public function getAmountAttribute() {
        return $this->stocks()->sum('amount');
    }

    public function trader() {
        return $this->belongsTo(Trader::class, 'trader_id','id');
    }

    public function input() {
        return $this->belongsTo(Input::class, 'input_id','id');
    }

    public function input_unit() {
        return $this->belongsTo(InputUnit::class, 'input_unit_id', 'id');
    }

    public function inputs() {
        return $this->hasMany(inputOrderItems::class);
    }

    public function stocks() {
        return $this->hasMany(Stock::class);
    }
}
