<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class InputDeliveryConfirm extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_input_delivery_confirms';

    protected $fillable = [
        'comment',
        'input_order_items_release_id',
        'trader_id',
        'state_of_arrival'
     ];
     public function trader() {
         return $this->belongsTo(Trader::class,'trader_id','id');
      }
      public function delivery() {
         return $this->belongsTo(InputOrderItemsRelease::class,'input_order_items_release_id','id');
      }
}
