<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class InputCategory extends Model
{
    //use HasTradingPrefix;

    protected $table = 'trading_input_categories';

    protected $fillable = [
        'name',
        'description',
        'parent_id'
    ];

    /**
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
        'url',
        'parent_name'
    ];

    public function inputs() {
        return $this->hasMany(Input::class, 'category_id');
    }

    public function children() {
        return $this->hasMany(InputCategory::class, 'parent_id');
    }

    public function categories() {
        return $this->HasMany(InputCategory::class);
    }

    public function childrenCategories() {
        return $this->hasMany(InputCategory::class)->with('categories');
    }

    public function parent() {
        return $this->belongsTo(InputCategory::class, 'parent_id');
    }

    public function scopeMain($query) {
        $query->whereNull('parent_id');
    }

    /**
     * Get the url for this model.
     *
     * @return URL
     */
    public function getUrlAttribute()
    {
        return route("input-categories.show", $this);
    }

    /**
     * Get the parent name for this model.
     *
     * @return URL
     */
    public function getParentNameAttribute()
    {
        return isset($this->parent) ? $this->parent->name : '';
    }
}
