<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTradingPrefix;

class Input extends Model
{
    //use HasTradingPrefix;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'trading_input';

    protected $fillable = [
        'category_id',
        'name',
        'description',
        'listed'
    ];

    /**
     * Add url attributes to the model.
     *
     * @var array
     */
    protected $appends = [
        'url',
        'category_name'
    ];

    public function input_items() {
        return $this->hasMany(InputItem::class);
    }

    public function category() {
        return $this->belongsTo(InputCategory::class, 'category_id');
    }


    /**
     * Get the url for this model.
     *
     * @return URL
     */
    public function getUrlAttribute()
    {
        return route("inputs.show", $this);
    }

    /**
     * Get the url for this model.
     *
     * @return URL
     */
    public function getCategoryNameAttribute()
    {
        return $this->category->name;
    }

}
