<?php

namespace App\Imports;

use Illuminate\Support\Facades\Hash;
use DateTime;
use App\User;
use App\TraderMember;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Imports\HeadingRowFormatter;

HeadingRowFormatter::default('none');

class TraderMembersImport implements ToCollection, WithHeadingRow
{
    protected $trader_id;

    public function __construct($trader_id) {
        $this->trader_id = $trader_id;
    }

    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function collection(Collection $rows)
    {
        foreach($rows as $row) {
            $user = User::create([
                'firstname' => $row['Firstname'],
                'lastname' => $row['Lastname'],
                'email' => $row['Email'],
                'email_canonical' => $row['Email'],
                'phone' => $row['Phone'],
                'username' => $row['Username'],
                'username_canonical' => $row['Username'],
                'password' => Hash::make($row['Password']),
                'locked' => 0,
                'enabled' => 1,
                'user_id' => 0,
                'expired' => 0,
                'address' => null,
                'credentials_expired' => 0,
                'salt' => Hash::make("password"),
                'roles' => serialize([]),
                'registration_date' => new DateTime(),
                'active' => 1,
                'status' => 6,
                'official_code' => 'anonymous',
                'language' => 'english',
            ]);

            TraderMember::create([
                'trader_id' => $this->trader_id,
                'user_id' => $user->id,
                'active' => $row['Active'],
            ]);
        }
    }
}
