<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class FarmerOrganisationMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $trader = Auth::user()->getRelatedTrader();
        if( Auth::user()->isAdmin() || $trader->isFarmerOrganisation() )
            return $next($request);

        return response()->redirectToAction('/dashboard');
    }
}
