<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class BuyerMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $trader = Auth::user()->getRelatedTrader();
        if( $trader->isBulkBuyer() )
            return $next($request);
        return response()->redirectToAction('/dashboard');
    }
}
