<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class AgentMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $trader = Auth::user()->getRelatedTrader();
        if( $trader->isAgent() )
            return $next($request);
        return response()->redirectToAction('/dashboard');
    }
}
