<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\TraderMember;
use App\Trader;
use App\User;   
use App\Expert_Videos;
use Auth;
use App\Chat;
use EloquentBuilder;
use DB;

class VideoQuestionController extends Controller
{
    public function __construct()
	{
	    $this->middleware('auth');
	}
    public function index()
    {
    $trader = Auth::user()->userAgent;
    $trader_arr = [];
    foreach($trader as $traderobj)
    {
        $traderid = $traderobj->trader_id;
        array_push($trader_arr,$traderid);
    }

    $fos=Trader::whereIn('id',$trader_arr)->get(); 

    $expert_messages=Expert_Videos::with('videoFarmer')->with('videoCoach')->with('videoOrganization')->get();
    //$expert_messages = EloquentBuilder::to($query,request()->all())->get();

    $query=TraderMember::whereIn('trader_id',$trader_arr);
    $allfarmers = EloquentBuilder::to($query,request()->all())->get();
    
    $selectedtrader = Trader::where('id',json_decode(request()->trader))->pluck('organisation_name');
    return view('videoquestions.index', compact('expert_messages','allfarmers','fos','selectedtrader'));
    
    }

    public function destroy($id)
    {
       
        $video = Expert_Videos::find($id);
        $video->delete();
            return redirect()->back()->with("success","Videos Deleted Successfully!");
    }
    public function confirm($id, Request $request)
    {
        $video = Expert_Videos::findOrFail($id);
        $video->status = '1';
        $video->save();
        
        return redirect()->back()->with("success","Videos Confirmed Successfully!");
    }
    //test chat
    public function showTest(){
        return view('videoquestions.testfile');
    }

    public function chatIndex(){
        $chats= Chat::where('farmer_id',1)->get();
        return $chats;
        //return view('chat.index');
    }

}
